import json
import logging
from jsonschema import validate
from cse_image_items.BaseItem import BaseItem
from cse_image_items.DataItem import DataItem


logger = logging.getLogger(__name__)
MANIFEST_HEADER_JSON = 'layout/manifest_header.json'
MANIFEST_HEADER_SCHEMA_JSON = 'layout/JSON schemas/manifest_header.json'


class ManifestHeader(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START ManifestHeader.__init__ FUNCTION')

        try:
            with open(MANIFEST_HEADER_JSON) as manifest_header_json:
                manifest_header = json.load(manifest_header_json)
            with open(MANIFEST_HEADER_SCHEMA_JSON) as manifest_header_schema_json:
                manifest_header_schema = json.load(manifest_header_schema_json)
            validate(instance=manifest_header, schema=manifest_header_schema)
        except Exception:
            logger.info('Exception occurred while reading manifest header JSON file')
            raise Exception('Exception occurred while reading manifest header JSON file')
        super(ManifestHeader, self).__init__(data, **manifest_header)
        self.version = DataItem(self.value, **manifest_header['version'])
